/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import OreSpawn.entities.AntRobot;
import OreSpawn.entities.Jeffery;
import OreSpawn.entities.RoboBomb;
import OreSpawn.entities.RoboGunner;
import OreSpawn.entities.RoboPounder;
import OreSpawn.entities.RoboSniper;
import OreSpawn.entities.SpiderRobot;
import OreSpawn.entities.ThrownLaserball;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class RoboWarrior
extends EntityLiving {
    private int reloadticker = 0;

    public RoboWarrior(World w) {
        super(w);
        this.maxrenderdist = 190;
        this.height = 7.75f;
        this.width = 3.25f;
        this.uniquename = "OreSpawn:RoboWarrior";
        this.moveSpeed = 0.28f;
        this.setMaxHealth(110.0f);
        this.setHealth(110.0f);
        this.setDefense(4.5f);
        this.setAttackDamage(60.0f);
        this.searchDistance = 32.0f;
        this.attackRange = 3.0f;
        this.movefrequency = 25;
        this.setExperience(220);
        this.canSwim = false;
        this.temperament = 1;
        this.enable_hostile = true;
        this.daytimespawn = false;
        this.daytimedespawn = true;
        this.nighttimespawn = true;
        this.nighttimedespawn = false;
        this.tower_defense_enable = true;
    }

    public void doEntityAction(float deltaT) {
        if (this.reloadticker > 0) {
            --this.reloadticker;
        }
        super.doEntityAction(deltaT);
    }

    public void doDistanceAttack(Entity victim) {
        double startz;
        double starty;
        if (this.reloadticker > 0) {
            return;
        }
        double startx = this.posx + (double)((float)Math.sin(Math.toRadians(this.rotation_yaw_head - 20.0f)) * this.getWidth() * (float)Math.cos(Math.toRadians(this.rotation_pitch_head)));
        ThrownLaserball e = (ThrownLaserball)this.world.createEntityByName("OreSpawn:ThrownLaserball", this.dimension, startx, starty = this.posy + (double)(this.getHeight() * 0.71f), startz = this.posz + (double)((float)Math.cos(Math.toRadians(this.rotation_yaw_head - 20.0f)) * this.getWidth() * (float)Math.cos(Math.toRadians(this.rotation_pitch_head))));
        if (e != null) {
            e.init();
            e.setBID(0);
            e.setIID(OreSpawnMain.laserball.itemID);
            e.thrower = this;
            float hdist = (float)Math.sqrt((victim.posx - startx) * (victim.posx - startx) + (victim.posz - startz) * (victim.posz - startz));
            float tdirxz = (float)Math.atan2(victim.posx - startx, victim.posz - startz);
            float tdiry = (float)Math.atan2(starty - (victim.posy + (double)(victim.getHeight() / 2.0f)), hdist);
            e.setDirectionAndVelocity((float)Math.sin(tdirxz) * (float)Math.cos(tdiry), -((float)Math.sin(tdiry)), (float)Math.cos(tdirxz) * (float)Math.cos(tdiry), 15.0f, 0.025f);
            this.world.spawnEntityInWorld((Entity)e);
        }
        int which = this.world.rand.nextInt(6);
        String s = null;
        if (which == 0) {
            s = "OreSpawn:laser1";
        }
        if (which == 1) {
            s = "OreSpawn:laser2";
        }
        if (which == 2) {
            s = "OreSpawn:laser3";
        }
        if (which == 3) {
            s = "OreSpawn:laser4";
        }
        if (which == 4) {
            s = "OreSpawn:laser5";
        }
        if (which == 5) {
            s = "OreSpawn:laser6";
        }
        this.world.playSound(s, this.dimension, this.posx, this.posy + (double)this.getHeight(), this.posz, 1.0f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
        this.reloadticker = 15;
    }

    public String getLivingSound() {
        if (this.world.rand.nextBoolean()) {
            return null;
        }
        int which = this.world.rand.nextInt(4);
        if (which == 0) {
            return "OreSpawn:robot_living1";
        }
        if (which == 1) {
            return "OreSpawn:robot_living2";
        }
        if (which == 2) {
            return "OreSpawn:robot_living3";
        }
        return "OreSpawn:robot_living4";
    }

    public String getHurtSound() {
        int which = this.world.rand.nextInt(8);
        if (which == 0) {
            return "OreSpawn:robot_hurt1";
        }
        if (which == 1) {
            return "OreSpawn:robot_hurt2";
        }
        if (which == 2) {
            return "OreSpawn:robot_hurt3";
        }
        if (which == 3) {
            return "OreSpawn:robot_hurt4";
        }
        if (which == 4) {
            return "OreSpawn:robot_hurt5";
        }
        if (which == 5) {
            return "OreSpawn:robot_hurt6";
        }
        if (which == 6) {
            return "OreSpawn:robot_hurt7";
        }
        return "OreSpawn:robot_hurt8";
    }

    public String getDeathSound() {
        int which = this.world.rand.nextInt(6);
        if (which == 0) {
            return "OreSpawn:robot_death1";
        }
        if (which == 1) {
            return "OreSpawn:robot_death2";
        }
        if (which == 2) {
            return "OreSpawn:robot_death3";
        }
        if (which == 3) {
            return "OreSpawn:robot_death4";
        }
        if (which == 4) {
            return "OreSpawn:robot_death5";
        }
        return "OreSpawn:robot_death6";
    }

    public void doDeathDrops() {
        int i = 0;
        while (i < 6) {
            if (this.world.rand.nextInt(4) == 1) {
                Utils.doDropRand((World)this.world, (int)0, (int)Items.dark.itemID, (float)3.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            }
            if (this.world.rand.nextInt(4) == 1) {
                Utils.doDropRand((World)this.world, (int)0, (int)Items.light.itemID, (float)3.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            }
            if (this.world.rand.nextInt(4) == 1) {
                Utils.doDropRand((World)this.world, (int)0, (int)Items.instability.itemID, (float)3.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            }
            if (this.world.rand.nextInt(4) == 1) {
                Utils.doDropRand((World)this.world, (int)0, (int)Items.lumpcopper.itemID, (float)3.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            }
            if (this.world.rand.nextInt(4) == 1) {
                Utils.doDropRand((World)this.world, (int)0, (int)Items.lumptin.itemID, (float)3.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            }
            if (this.world.rand.nextInt(4) == 1) {
                Utils.doDropRand((World)this.world, (int)0, (int)Items.lumpsilver.itemID, (float)3.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            }
            if (this.world.rand.nextInt(4) == 1) {
                Utils.doDropRand((World)this.world, (int)0, (int)Items.lumpplatinum.itemID, (float)3.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            }
            if (this.world.rand.nextInt(8) == 1) {
                Utils.doDropRand((World)this.world, (int)Blocks.blockcopper.blockID, (int)0, (float)3.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            }
            if (this.world.rand.nextInt(8) == 1) {
                Utils.doDropRand((World)this.world, (int)Blocks.blocktin.blockID, (int)0, (float)3.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            }
            if (this.world.rand.nextInt(8) == 1) {
                Utils.doDropRand((World)this.world, (int)Blocks.blocksilver.blockID, (int)0, (float)3.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            }
            if (this.world.rand.nextInt(8) == 1) {
                Utils.doDropRand((World)this.world, (int)Blocks.blockplatinum.blockID, (int)0, (float)3.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            }
            ++i;
        }
        i = 0;
        while (i < 20) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.laserball.itemID, (float)3.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.raygun.itemID, (float)3.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        if (this.world.rand.nextInt(4) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophyrobowarrior.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        super.doDeathDrops();
    }

    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof RoboBomb) {
            return false;
        }
        if (e instanceof RoboPounder) {
            return false;
        }
        if (e instanceof RoboGunner) {
            return false;
        }
        if (e instanceof RoboWarrior) {
            return false;
        }
        if (e instanceof RoboSniper) {
            return false;
        }
        if (e instanceof Jeffery) {
            return false;
        }
        if (e instanceof AntRobot) {
            return false;
        }
        if (e instanceof SpiderRobot) {
            return false;
        }
        if (e instanceof Player && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e.temperament == 1 && this.CanProbablySeeEntity(e);
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/RoboWarriortexture.png");
        }
        return this.texture;
    }

    public boolean isBoss() {
        return true;
    }

    public String getBossName() {
        return "Robo-Warrior";
    }
}

